***
clear all
set more off
set scheme texeps

global path = "$HOME/research/ssur"
global epspath = "$HOME/research/ssur/analysis-bpea/charts"

*** UR and SSUR
* steady state unemployment rate implied by hazards
use $path/analysis-bpea/ssur_data.dta, clear
gen ur = 100*u/(e+u)
gen ssur=100*s/(s+f)
gen ssdev = ssur-ur
*
tscollap (mean) ur ssur ssdev, to(q) gen(qdate)
set obs `=_N+1'
replace qdate = tq(1950q1) in l
tsfill
set obs `=_N+1'
replace qdate = tq(2012q4) in l
tsfill
*
merge 1:1 qdate using $path/analysis-bpea/recq.dta, keep(1 3) nogen
gen recbar=.
gen zero=0
gen top=12
label var ur "Unemployment rate"
label var ssur "{it:u}*"
label var ssdev "Deviation"
*
replace recbar=12*rec
#delim ;
tw  (bar recbar qdate, base(-2) col(gs12) fi(100))
    (line top qdate, lc(gs0) lw(vthin))
    (line ur qdate, lc(black) lw(medium))
    (line ssur qdate, lc(black) lw(thin) lp("-"))
    (line zero qdate, yaxis(2) lc(gs0) lw(thin))
    (line ssdev qdate, yaxis(2) lc(black) lw(medthin))
    if qdate>=tq(1950q1),
    xtitle("")
    xlab(-39  "1950"
           1  "1960"
          41  "1970"
          81  "1980"
         121  "1990"
         161  "2000"
         201  "2010"
         , notick)
    xtick(-40.5(4)211.5)
    legend(order(3 4 6) row(3) bm(3 0 0 1))
    ysca(r(1 12)) ylab(3(1)11, for(%4.0f))
    ysca(r(-1 8) axis(2)) ylab(-.5(.5)1, axis(2) for(%4.1f)) ytick(-.5(.5)1 8,axis(2))
    subtitle("Percent")
    name(ur_ssurq, replace)
    ;
#delim cr
if "$S_OS"=="Unix" {
  graph export $epspath/ur-ssur.eps, font(Times) replace
  !gv $epspath/ur-ssur.eps&
  shell epstopdf $epspath/ur-ssur.eps
}
*/

*** CONVERGENCE SPEED & HAZARDS
** hazards
use $path/analysis-bpea/models/rt/fhist-ssur2.dta, clear
keep mdate *631
rename ur_631 ur
rename s_631 s
rename f_631 f
tsset mdate, m
keep if mdate<631
qui replace s=. in l
qui replace f=. in l
*
tscollap (mean) ur s f, to(q) gen(qdate)
gen ls = ln(100*s)
gen lf = ln(100*f)
*
set obs `=_N+1'
replace qdate = tq(1949q4) in l
tsfill
set obs `=_N+1'
replace qdate = tq(2012q4) in l
tsfill
*
merge 1:1 qdate using $path/analysis-bpea/recq.dta, keep(1 3) nogen
gen recbar=1.7*rec
gen top=1.7
label var ls "Inflow"
label var lf "Outflow"
*
#delim ;
tw  (bar recbar qdate, col(gs12) fi(100))
    (line top qdate, lc(gs0) lw(vthin))
    (line ls qdate, lc(black) lw(thin))
    (line lf qdate, lc(black) lw(medthick) yaxis(2))
    if qdate>=tq(1950q1),
    xtitle("")
    xlab(-39  "1950"
           1  "1960"
          41  "1970"
          81  "1980"
         121  "1990"
         161  "2000"
         201  "2010"
         , notick)
    xtick(-40.5(4)211.5)
    ytitle("") ytitle("", axis(2))
    legend(order(3 4 6) row(3) pos(1) bm(0 3 0 1))
    ysca(r(.8 1.7)) ylab(.9(.1)1.6, for(%4.1f)) ytick(.8(.1)1.7)
    ysca(r(3.0 4.8) axis(2)) ylab(3.2(.2)4.6, axis(2) for(%4.1f)) ytick(3.0(.2)4.8, axis(2))
    title("{bf:Unemployment Inflows and Outlflows}", size(medsmall))
    subtitle("Log points                                                                                         Log points")
    name(lslf, replace)
    ;
#delim cr
** conv spd.
use $path/analysis-bpea/ssur_data.dta, clear
gen converge = -ln(0.1)/(s+f)
tscollap converge, to(q) gen(qdate)
order qdate
*
merge 1:1 qdate using $path/analysis-bpea/recq.dta, nogen
gen recbar=10*rec
gen top=10
gen bottom=2
#delim ;
tw  (bar recbar qdate, col(gs12) fi(100) yaxis(1 2))
    (line top qdate, lc(gs0) lw(vthin))
    (line bottom qdate, lc(gs0) lw(vthin))
    (line converge qdate, lc(black))
    if qdate>=tq(1950q1),
    xtitle("")
    xlab(-39  "1950"
           1  "1960"
          41  "1970"
          81  "1980"
         121  "1990"
         161  "2000"
         201  "2010"
         , notick)
    xtick(-40.5(4)211.5)
    ylab(3(1)9, nogrid nolab) ylab(3(1)9, axis(2))
    yline(10, lc(gs0) lw(thin))
    legend(off)
    title("{bf:Convergence to Steady-State Unemployment Rate}", size(medsmall))
    graphregion(margin(l+6.5 r+1.75))
    subtitle("Months", pos(1) nospan)
    name(convergence, replace)
      ;
#delim cr
*
graph combine lslf convergence, row(2) iscale(1) graphr(m(tiny)) ysize(4)
if "$S_OS"=="Unix" {
  graph export $epspath/lslf-conv.eps, font(Times) replace
  !gv $epspath/lslf-conv.eps&
  shell epstopdf $epspath/lslf-conv.eps
}
*/

*** GR TESTS
import excel "$path/analysis-bpea/GRtests.xlsx", sheet("GRtest_ARIMA") cellrange(A1:D515) firstrow clear
gen mdate = monthly(fcdate,"YM")
tsset mdate, m
set obs `=_N+1'
replace mdate=tm(2012m12) in l
tsfill
*
destring t0, replace force
destring t1, replace force
destring t2, replace force
gen cv_lo = -3.17
gen cv_hi = 3.17
*
merge 1:1 mdate using $path/analysis-bpea/recm.dta, keep(1 3) nogen
gen recbar=.
gen top=.
gen zero=0
*
label var t0 "Same-quarter"
label var t1 "One-quarter-ahead"
label var t2 "Two-quarter-ahead"
*
replace recbar=11*rec
replace top=11
#delim ;
tw  (bar recbar mdate, yaxis(1 2) base(-1) col(gs12) fi(100))
    (line top mdate, lc(gs0) lw(vthin))
    (line zero mdate, lc(gs0) lw(thin))
    (line cv_hi mdate, lc(red) lw(thin) lp(dash))
/*    (line t2 mdate, lc(black) lw(medthin) lp("_."))*/
    (line t1 mdate, lc(black) lw(medthin) lp("-"))
    (line t0 mdate, lc(black) lw(medium)),
    xtitle("")
    tlab(1970m7(60)2010m7, for(%tmCCYY) notick labs(medsmall))
    ttick(1970m1(12)2013m1)
    legend(order(6 5) row(2) bm(3 0 0 1) size(medsmall))
    ysca(r(-1 11)) ylab(0(1)10, for(%3.0f) labs(medsmall))
    ysca(r(-1 11) axis(2)) ylab(0(1)10, nolab axis(2))
    subtitle("Relative performance", size(medsmall) pos(11))
    name(gr_t0, replace)
    ;
#delim cr
if "$S_OS"=="Unix" {
  graph export $epspath/gr-test.eps, font(Times) replace
  !gv $epspath/gr-test.eps&
  shell epstopdf $epspath/gr-test.eps
}
*/

*** VAR IRF
local step = 12
*
use $path/analysis-bpea/ssur_data.dta, clear
gen ur = u/(u+e)
drop e u n p u_s ??r
order mdate ur
tsset mdate, m
tscollap s f ur uic hwi, to(q) gen(qdate)
sort qdate
order qdate
*
gen ls = ln(s)
gen lf = ln(f)
gen lur = ln(ur)
*
noi var ls lf lur if qdate<=tq(2007q4), lags(1/2)
irf create irf, step(`step') set(irf, replace)
*
* create IRF
*ls
irf create irf, step(`step') set(irf, replace)
log using lsls.log, text replace
noi irf table irf, impulse(ls) response(ls) level(95) std title("")
log close
log using lslf.log, text replace
noi irf table irf, impulse(ls) response(lf) level(95) std title("")
log close
log using lslur.log, text replace
noi irf table irf, impulse(ls) response(lur) level(95) std title("")
log close
foreach irf in lsls lslf lslur {
  tempfile `irf'
  tempname fhr fhw
  local linenum = 0
  file open `fhr' using `irf'.log, read
  file open `fhw' using `irf'.dat, write replace
  file read `fhr' line
  while r(eof)==0 {
    local linenum = `linenum' + 1
    if `linenum'>=8 & `linenum'<=`step'+8 {
      file write `fhw' `"`macval(line)'"' _n
    }
    file read `fhr' line
  }
  file close `fhr'
  file close `fhw'
  infix step 2-3 double `irf' 12-21 double `irf'_lb 24-33 double `irf'_ub 36-44 using `irf'.dat, clear
  erase `irf'.dat
  save ``irf''
}
*
use `lsls', clear
foreach irf in lslf lslur {
  merge 1:1 step using ``irf'', nogen
}
compress
*save hr-irf-q.dta, replace
*/

*use hr-irf-q.dta, replace
gen zero=0
gen top=2.5
**ls
#delim ;
tw  (rarea lsls_ub lsls_lb step, col(gs12) fi(100))
    (rarea lsls_ub lsls_lb step, col(gs12) fi(100))
    (line top step, yaxis(1 2) lc(gs0) lw(vthin))
    (line zero step, lc(gs0) lw(thin))
    (line lsls step, lc(gs0) lw(medthick))
    ,
    xtitle("Quarter") xlab(0(2)`step', notick) xtick(-.5(1)`step'.5)
    ysca(r(-2.5 2.5)) ylab(-2(1)2, nolab) ytick(-2.5(.5)2.5)
    ysca(r(-2.5 2.5) axis(2)) ylab(-2(1)2, axis(2)) ytick(-2.5(.5)2.5, axis(2))
    yline(0, lc(gs0) lw(thin)) yline(2.5, lc(gs0) lw(vthin))
    legend(off)
    title("{bf:Inflow}", nospan size(medsmall))
    graphr(m(tiny))
    name(lsls, replace)
    ;
tw  (rarea lslf_ub lslf_lb step, col(gs12) fi(100))
    (rarea lslf_ub lslf_lb step, col(gs12) fi(100))
    (line top step, yaxis(1 2) lc(gs0) lw(vthin))
    (line zero step, lc(gs0) lw(thin))
    (line lslf step, lc(gs0) lw(medthick))
    ,
    xtitle("Quarter") xlab(0(2)`step', notick) xtick(-.5(1)`step'.5)
    ysca(r(-2.5 2.5)) ylab(-2(1)2, nolab) ytick(-2.5(.5)2.5)
    ysca(r(-2.5 2.5) axis(2)) ylab(-2(1)2, axis(2)) ytick(-2.5(.5)2.5, axis(2))
    yline(0, lc(gs0) lw(thin)) yline(2.5, lc(gs0) lw(vthin))
    legend(off)
    title("{bf:Outflow}", nospan size(medsmall))
    graphr(m(tiny))
    name(lslf, replace)
    ;
tw  (rarea lslur_ub lslur_lb step, col(gs12) fi(100))
    (rarea lslur_ub lslur_lb step, col(gs12) fi(100))
    (line top step, yaxis(1 2) lc(gs0) lw(vthin))
    (line zero step, lc(gs0) lw(thin))
    (line lslur step, lc(gs0) lw(medthick))
    ,
    xtitle("Quarter") xlab(0(2)`step', notick) xtick(-.5(1)`step'.5)
    ysca(r(-2.5 2.5)) ylab(-2(1)2, nolab) ytick(-2.5(.5)2.5)
    ysca(r(-2.5 2.5) axis(2)) ylab(-2(1)2, axis(2)) ytick(-2.5(.5)2.5, axis(2))
    yline(0, lc(gs0) lw(thin)) yline(2.5, lc(gs0) lw(vthin))
    legend(off)
    title("{bf:Unemployment rate}", nospan size(medsmall))
    graphr(m(tiny))
    name(lslur, replace)
    ;
#delim cr
*
graph combine lsls lslf lslur, col(3) iscale(1) /*title("{bf:Shock to Inflow Rate}", size(medsmall)) name(ls) graphr(m(tiny))*/
*
if "$S_CONSOLE"=="console" {
  graph export $epspath/hr-irf-q.eps, font(Times) replace
  shell epstopdf $epspath/hr-irf-q.eps
  !gv -g +0+0 $epspath/hr-irf-q.eps&
  exit, clear STATA
}
*/


*** RECENT MISSES ***
tempfile spfur
use $path/data/spf/spf-unemp.dta, clear
drop *med*
reshape long ru_avg, i(qdate) j(j)
rename qdate date
gen int fcdate=mofd(dofq(date))+1
gen int qdate=date+j
gen ur_spf = ru_avg/100
drop if ur_spf==.
format fcdate %tm
tsset fcdate qdate, q
keep fcdate qdate ur_spf
qui replace ur_spf = round(ur_spf,.0001)
save `spfur', replace

*** V1 UR DATA
tempfile v1ur
use $path/data/rtdata/v1ur.dta, clear
replace v1ur=v1ur/100
tscollap v1ur, to(q) gen(qdate)
qui replace v1ur = round(v1ur,.0001)
tsset qdate, q
save `v1ur'

** BASELINE SSUR-2 FORECASTS
tempfile ssur2
use $path/analysis-bpea/models/rt/rt-ssur2.dta, clear
tsset fcdate mdate, m
* collapse to quarterly
tscollap ur_ssur2, to(q) gen(qdate)
* keep horizon t+0 to t+4
keep if qdate>=qofd(dofm(fcdate)) & qdate<qofd(dofm(fcdate))+5
qui replace ur_ssur2 = round(ur_ssur2,.0001)
save `ssur2'

** BASELINE SSUR-3 FORECASTS
tempfile ssur3
use $path/analysis-bpea/models/qrt/ssur3/qrt-ssur3.dta, clear
tsset fcdate mdate, m
* collapse to quarterly
tscollap ur_ssur3, to(q) gen(qdate)
* keep horizon t+0 to t+4
keep if qdate>=qofd(dofm(fcdate)) & qdate<qofd(dofm(fcdate))+5
qui replace ur_ssur3 = round(ur_ssur3,.0001)
save `ssur3'

use `spfur', clear
merge 1:1 fcdate qdate using `ssur2', nogen keep(1 3)
merge 1:1 fcdate qdate using `ssur3', nogen keep(1 3)
merge m:1 qdate using `v1ur', nogen keep(1 3)

sort fcdate qdate
keep if fcdate>=tm(2007m1)

keep if ur_spf!=.

gen res_spf = 100*(v1ur-ur_spf)
gen res_ssur2 = 100*(v1ur-ur_ssur2)
gen res_ssur3 = 100*(v1ur-ur_ssur3)

keep if qdate>=qofd(dofm(fcdate)) & qdate<=qofd(dofm(fcdate))+1

gen year=year(dofm(fcdate))
gen qtr = string(qofd(dofm(fcdate)),"%tq!Qq")

label var res_spf "SPF"
label var res_ssur2 "SSUR-2"
label var res_ssur3 "SSUR-3"
#delim ;
graph bar (asis) res_spf res_ssur2 res_ssur3
  if obs==1 & fcdate>=tm(2007m2) & fcdate<=tm(2012m12),
  bar(1, fc(gs16) lc(gs0) lw(vthin))
  bar(2, fc(gs10) lc(gs0) lw(vthin))
  bar(3, fc(gs3) lc(gs0) lw(vthin))
  over(qtr, sort(fcdate) label(labgap(tiny) labsize(medsmall)) axis(line lw(thin)))
  over(year, label(labgap(zero)))
  legend(col(3) pos(11) symy(*.5) symx(*.5) bm(2 0 0 1))
  ylab(-.8(.4)1.2, for(%03.1f) nogrid)
  title("{bf:Current-Quarter}", size(medsmall))
  subtitle("Percentage point", size(medsmall) pos(11))
  yline(0, lc(gs0) lw(thin)) plotr(m(zero) lsty(solid) lw(thin))
  graphr(m(1 1 2 1))
  name(miss0, replace)
  ;
graph bar (asis) res_spf res_ssur2 res_ssur3
  if obs==2 & fcdate>=tm(2007m2) & fcdate<=tm(2012m12),
  bar(1, fc(gs16) lc(gs0) lw(vthin))
  bar(2, fc(gs10) lc(gs0) lw(vthin))
  bar(3, fc(gs3) lc(gs0) lw(vthin))
  over(qtr, sort(fcdate) label(labgap(tiny) labsize(medsmall)) axis(line lw(thin)))
  over(year, label(labgap(zero)))
  /*legend(col(3) pos(7) bm(3 0 3 0))*/ legend(off)
  ylab(-.8(.4)1.2, for(%03.1f) nogrid)
  title("{bf:One-Quarter-Ahead}", size(medsmall))
  yline(0, lc(gs0) lw(thin)) plotr(m(zero) lsty(solid) lw(thin))
  graphr(m(1 1 1 2))
  name(miss1, replace)
  ;
#delim cr
graph combine miss0 miss1, row(2) iscale(1)
if "$S_OS"=="Unix" {
  graph export $epspath/recent-miss.eps, font(Times) replace
  !gv $epspath/recent-miss.eps&
  shell epstopdf $epspath/recent-miss.eps
}

*/

if "$S_CONSOLE"=="console" exit, STATA clear
